<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CarritoProveedor extends Model
{
    protected $table = 'carrito_proveedores';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'id_carrito', 'id_proveedor', 
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'updated_at', 'deleted_at'
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    // public function stoks(){
    //     return $this->hasMany(Stock::class, 'id_producto');
    // }

    public function carrito(){
        return $this->belongsTo(Carrito::class, 'id_carrito');
    }

    public function proveedor(){
        return $this->belongsTo(User::class, 'id_proveedor');
    }

    public function carritoProductos(){
        return $this->hasMany(CarritoProducto::class, 'id_carrito_proveedor');
    }

}
