<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CarritoProducto extends Model
{
    protected $table = 'carrito_productos';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'id_carrito_proveedor', 'id_producto', 'cantidad'
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'updated_at', 'deleted_at'
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    // public function stoks(){
    //     return $this->hasMany(Stock::class, 'id_producto');
    // }

    public function carritoProveedor(){
        return $this->belongsTo(CarritoProveedor::class, 'id_carrito_proveedor');
    }

    public function productoProveedor(){
        return $this->belongsTo(ProductoProveedor::class, 'id_producto');
    }

    public function oferta(){
        return $this->hasOne(OfertaProveedor::class, 'id_carrito_producto');
    }

}
