<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Carrito extends Model
{
    protected $table = 'carritos';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'id_user', 'id_proveedor', 'estado', 'valor_total',
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'deleted_at'
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    // public function stoks(){
    //     return $this->hasMany(Stock::class, 'id_producto');
    // }

    public function carritoProveedores(){
        return $this->hasMany(CarritoProveedor::class, 'id_carrito');
    }

    public function usuario(){
        return $this->belongsTo(User::class, 'id_user');
    }

}
